<div class="headerNav py-3">
    <div class="container-fluid px-md-5 ">

        <nav class="navbar navbar-expand-xl navbar-light  mx-lg-5" id="boltd">
            <a class="navbar-brand" href="<?php echo e(route('home')); ?>">
                <img src="<?php echo e(getFile(config('location.logoIcon.path').'logo.png')); ?>" alt="homepage"
                     class="dark-logo" />
            </a>
            <button class="navbar-toggler " type="button" data-toggle="collapse" data-target="#navbarSupportedContent"
                    aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse" id="navbarSupportedContent">


                <ul class="navbar-nav ml-auto  align-items-end align-items-sm-center">
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(Request::routeIs('user.home')  ? 'active' : ''); ?>"
                           href="<?php echo e(route('user.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?> </a>
                    </li>

                    <li class="nav-item dropdown <?php echo e(Request::routeIs('user.order*') ? 'active' : ''); ?>">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button"
                           data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <?php echo app('translator')->get('Order'); ?>
                            <i data-feather="chevron-down" class="svg-icon"></i>
                        </a>
                        <div class="dropdown-menu" aria-labelledby="navbarDropdown">
                            <a class="dropdown-item <?php echo e(menuActive('user.order.create')); ?>" href="<?php echo e(route('user.order.create')); ?>"><?php echo app('translator')->get('New Order'); ?></a>
                            <a class="dropdown-item <?php echo e(menuActive('user.order.mass')); ?>" href="<?php echo e(route('user.order.mass')); ?>"><?php echo app('translator')->get('Mass Order'); ?></a>
                            <a class="dropdown-item <?php echo e(menuActive('user.order.index')); ?>" href="<?php echo e(route('user.order.index')); ?>"><?php echo app('translator')->get('All Order'); ?></a>
                        </div>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link <?php echo e(Request::routeIs('user.service*')  ? 'active' : ''); ?>"
                           href="<?php echo e(route('user.service.show')); ?>"><?php echo app('translator')->get('Services'); ?> </a>
                    </li>
                    <li class="nav-item  ">
                        <a class="nav-link <?php echo e(Request::routeIs('user.addFund*')  ? 'active' : ''); ?>"
                           href="<?php echo e(route('user.addFund')); ?>"><?php echo app('translator')->get('Add Fund'); ?></a>
                    </li>



                    <li class="nav-item ">
                        <a class="nav-link <?php echo e(Request::routeIs('user.fund-history') ? 'active' : ''); ?>"
                           href="<?php echo e(route('user.fund-history')); ?>"><?php echo app('translator')->get('Fund History'); ?></a>
                    </li>

                    <li class="nav-item ">
                        <a class="nav-link <?php echo e(Request::routeIs('user.transaction') ? 'active' : ''); ?>"
                           href="<?php echo e(route('user.transaction')); ?>"><?php echo app('translator')->get('Transactions'); ?> </a>
                    </li>


                    <li class="nav-item dropdown <?php echo e((Request::routeIs('user.profile') || Request::routeIs('user.api.docs') || Request::routeIs('user.ticket*')) ? 'active' : ''); ?>">
                        <a class="nav-link dropdown-toggle" href="javascript:void(0)" id="navbarDropdownUser"
                           role="button"
                           data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">

                            <img src="<?php echo e(getFile(config('location.user.path').Auth::user()->image )); ?>"
                                 alt="<?php echo e(Auth::user()->name); ?>" class="rounded-circle" width="40px">
                            <span><?php echo e(Auth::user()->username); ?></span>
                            <i data-feather="chevron-down" class="svg-icon"></i>
                        </a>
                        <div class="dropdown-menu" aria-labelledby="navbarDropdownUser">
                            <a class="dropdown-item <?php echo e(menuActive('user.profile')); ?>" href="<?php echo e(route('user.profile')); ?>">
                                <i data-feather="user" class="svg-icon mr-2 ml-1"></i>
                                <?php echo app('translator')->get('My Profile'); ?></a>


                            <a class="dropdown-item <?php echo e(menuActive('user.api.docs')); ?>" href="<?php echo e(route('user.api.docs')); ?>">
                                <i data-feather="key" class="svg-icon mr-2 ml-1"></i> <?php echo app('translator')->get('API Setting'); ?>
                            </a>

                            <a class="dropdown-item <?php echo e(menuActive('user.ticket.create')); ?>" href="<?php echo e(route('user.ticket.create')); ?>">
                                <i class="fab fa-hire-a-helper mr-2 ml-1 icon-color"></i><?php echo app('translator')->get('Open Ticket'); ?>
                            </a>
                            <a class="dropdown-item <?php echo e(menuActive('user.ticket.list')); ?>" href="<?php echo e(route('user.ticket.list')); ?>">
                                <i class="fas fa-ticket-alt mr-2 ml-1 icon-color"></i> <?php echo app('translator')->get('Show Ticket'); ?>
                            </a>


                            <div class="dropdown-divider"></div>
                            <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                               onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();"><i
                                    data-feather="power" class="svg-icon mr-2 ml-1"></i>
                                <?php echo e(__('Logout')); ?>

                            </a>
                            <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                                <?php echo csrf_field(); ?>
                            </form>
                        </div>
                    </li>
                </ul>

            </div>


            <!-- Notification -->
            <div class="push-notification dropdown " id="pushNotificationArea">

                <a class="nav-link dropdown-toggle pl-md-3 position-relative" href="javascript:void(0)"
                   id="bell" role="button" data-toggle="dropdown" aria-haspopup="true"
                   aria-expanded="false">
                    <span><i class="far fa-bell bell-font"></i></span>
                    <span class="badge badge-primary notify-no rounded-circle" v-cloak>{{ items.length }}</span>

                </a>

                <div class="right-dropdown dropdown-menu dropdown-menu-right mailbox animated bounceInDown">
                    <ul class="list-style-none">
                        <li>
                            <div class="scrollable message-center notifications position-relative">

                                <!-- Message -->
                                <a v-for="(item, index) in items"
                                   @click.prevent="readAt(item.id, item.description.link)"
                                   href="javascript:void(0)"
                                   class="message-item d-flex align-items-center border-bottom px-3 py-2">
                                                <span class="btn btn-success text-white rounded-circle btn-circle">
                                                    <i :class="item.description.icon" class="text-white"></i>
                                                </span>

                                    <div class="d-inline-block v-middle pl-2">
                                        <span class="font-12  d-block text-muted"  v-cloak v-html="item.description.text"></span>
                                        <span class="font-12  d-block text-muted text-truncate"  v-cloak>{{ item.formatted_date }}</span>
                                    </div>
                                </a>

                            </div>
                        </li>

                        <li>
                            <a class="nav-link pt-3 text-center text-dark notification-clear-btn" href="javascript:void(0);"
                               v-if="items.length > 0" @click.prevent="readAll">
                                <strong><?php echo app('translator')->get('Clear all'); ?></strong>
                            </a>
                            <a class="nav-link pt-3 text-center text-dark" href="javascript:void(0);"
                               v-else>
                                <strong><?php echo app('translator')->get('No Data found'); ?></strong>
                            </a>

                        </li>
                    </ul>
                </div>


            </div>
            <!-- End Notification -->


        </nav>

    </div>

</div>
<?php /**PATH D:\server\htdocs\smmFinal\project\resources\views/user/layouts/header.blade.php ENDPATH**/ ?>