<?php $__env->startSection('title'); ?>
    <?php echo app('translator')->get('Dashboard'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="container">
        <div>
            <ol class="breadcrumb center-items">
                <li><a href="<?php echo e(route('user.home')); ?>"><?php echo app('translator')->get('Home'); ?></a></li>
                <li class="active"> <?php echo app('translator')->get('Dashboard'); ?></li>
            </ol>
        </div>


        <div class="row my-4 admin-fa_icon">

            <div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
                <div class="card shadow ">
                    <div class="card-body">
                        <div class="d-flex d-lg-flex d-md-block align-items-center justify-content-between">
                            <div>
                                <div class="d-inline-flex align-items-center">
                                    <h2 class="text-dark mb-1 font-weight-medium"><sup class="set-doller"><?php echo e(config('basic.currency_symbol')); ?></sup><?php echo e(getAmount($walletBalance)); ?>

                                    </h2>
                                </div>
                                <h6 class="text-muted font-weight-normal mb-0 w-100 text-truncate"><?php echo app('translator')->get('Your Balance'); ?></h6>
                            </div>

                            <div class=" mt-md-3 mt-lg-0">
                                <span class="opacity-7 text-muted"><i class="fa fa-suitcase fa-2x"></i></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
                <div class="card shadow">
                    <div class="card-body">
                        <div class="d-flex d-lg-flex d-md-block align-items-center justify-content-between">
                            <div>
                                <h2 class="text-dark mb-1 w-100 text-truncate font-weight-medium"><?php echo e(number_format($totalTrx)); ?></h2>
                                <h6 class="text-muted font-weight-normal mb-0 w-100 text-truncate"><?php echo app('translator')->get('Total Transaction'); ?>
                                </h6>
                            </div>

                            <div class=" mt-md-3 mt-lg-0">
                                <span class="opacity-7 text-muted"><i class="fas fa-exchange-alt fa-2x"></i></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
                <div class="card shadow">
                    <div class="card-body">
                        <div class="d-flex d-lg-flex d-md-block align-items-center justify-content-between">
                            <div>
                                <div class="d-inline-flex align-items-center">
                                    <h2 class="text-dark mb-1 font-weight-medium"><sup class="set-doller"><?php echo e(config('basic.currency_symbol')); ?></sup><?php echo e(getAmount($totalDeposit)); ?></h2>
                                </div>
                                <h6 class="text-muted font-weight-normal mb-0 w-100 text-truncate"><?php echo app('translator')->get('Total Deposit'); ?></h6>
                            </div>

                            <div class=" mt-md-3 mt-lg-0">
                                <span class="opacity-7 text-muted"><i class="fas fa-money-bill-alt fa-2x"></i></span>
                            </div>

                        </div>
                    </div>
                </div>
            </div>

            <div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
                <div class="card shadow">
                    <div class="card-body">
                        <div class="d-flex d-lg-flex d-md-block align-items-center justify-content-between">
                            <div>
                                <h2 class="text-dark mb-1 font-weight-medium"><?php echo e(getAmount($ticket)); ?></h2>
                                <h6 class="text-muted font-weight-normal mb-0 w-100 text-truncate"><?php echo app('translator')->get('Total Tickets'); ?></h6>
                            </div>

                            <div class="mt-md-3 mt-lg-0">
                                <span class="opacity-7 text-muted"><i class="fas fa-ticket-alt fa-2x"></i></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
                <div class="card shadow">
                    <div class="card-body">
                        <div class="d-flex d-lg-flex d-md-block align-items-center justify-content-between">
                            <div>
                                <div class="d-inline-flex align-items-center">
                                    <h2 class="text-dark mb-1 font-weight-medium"><?php echo e(getAmount($order['total'])); ?></h2>
                                </div>
                                <h6 class="text-muted font-weight-normal mb-0 w-100 text-truncate"><?php echo app('translator')->get('Total Orders'); ?></h6>
                            </div>

                            <div class=" mt-md-3 mt-lg-0">
                                <span class="opacity-7 text-muted"><i class="fab fa-first-order fa-2x"></i></span>
                            </div>

                        </div>
                    </div>
                </div>
            </div>

            <div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
                <div class="card shadow">
                    <div class="card-body">
                        <div class="d-flex d-lg-flex d-md-block align-items-center justify-content-between">
                            <div>
                                <h2 class="text-dark mb-1 font-weight-medium"><?php echo e(getAmount($order['processing'])); ?></h2>
                                <h6 class="text-muted font-weight-normal mb-0 w-100 text-truncate"><?php echo app('translator')->get('Processing Orders'); ?></h6>
                            </div>

                            <div class=" mt-md-3 mt-lg-0">
                                <span class="opacity-7 text-muted"><i class="fab fa-first-order fa-2x"></i></span>
                            </div>

                        </div>
                    </div>
                </div>
            </div>

            <div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
                <div class="card shadow">
                    <div class="card-body">
                        <div class="d-flex d-lg-flex d-md-block align-items-center justify-content-between">
                            <div>
                                <h2 class="text-dark mb-1 font-weight-medium"><?php echo e(getAmount($order['pending'])); ?></h2>
                                <h6 class="text-muted font-weight-normal mb-0 w-100 text-truncate"><?php echo app('translator')->get('Pending Orders'); ?></h6>
                            </div>

                            <div class=" mt-md-3 mt-lg-0">
                                <span class="opacity-7 text-muted"><i class="fas fa-spinner fa-2x"></i></span>
                            </div>

                        </div>
                    </div>
                </div>
            </div>

            <div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
                <div class="card shadow">
                    <div class="card-body">
                        <div class="d-flex d-lg-flex d-md-block align-items-center justify-content-between">
                            <div>
                                <h2 class="text-dark mb-1 font-weight-medium"><?php echo e(getAmount($order['completed'])); ?></h2>
                                <h6 class="text-muted font-weight-normal mb-0 w-100 text-truncate"><?php echo app('translator')->get('Completed Orders'); ?></h6>
                            </div>

                            <div class=" mt-md-3 mt-lg-0">
                                <span class="opacity-7 text-muted"><i class="fas fa-check fa-2x"></i></span>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-body ">
                        <h4 class="card-title"><?php echo app('translator')->get('Latest Transaction'); ?></h4>

                        <div class="table-responsive">
                            <table class="table table table-hover table-striped " id="service-table">
                                <thead class="ca">
                                <tr>
                                    <th ><?php echo app('translator')->get('Transaction ID'); ?></th>
                                    <th ><?php echo app('translator')->get('Amount'); ?></th>
                                    <th ><?php echo app('translator')->get('Remarks'); ?></th>
                                    <th><?php echo app('translator')->get('Time'); ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td data-label="<?php echo app('translator')->get('Transaction ID'); ?>"><?php echo app('translator')->get($transaction->trx_id); ?></td>
                                        <td data-label="<?php echo app('translator')->get('Amount'); ?>">
                                        <span
                                            class="font-weight-bold text-<?php echo e(($transaction->trx_type == "+") ? 'success': 'danger'); ?>"><?php echo e(($transaction->trx_type == "+") ? '+': '-'); ?><?php echo e(getAmount($transaction->amount, config('basic.fraction_number')). ' ' . trans(config('basic.currency'))); ?></span>
                                        </td>
                                        <td data-label="<?php echo app('translator')->get('Remarks'); ?>"> <?php echo app('translator')->get($transaction->remarks); ?></td>
                                        <td data-label="<?php echo app('translator')->get('Time'); ?>">
                                            <?php echo e(dateTime($transaction->created_at, 'd M Y h:i A')); ?>

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>

                        </div>


                    </div>
                </div>
            </div>
        </div>

    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\server\htdocs\codecanyon-exoVhLVV-smm-matrix-social-media-marketing-tool\project\resources\views/user/pages/dashboard.blade.php ENDPATH**/ ?>