<?php $__env->startSection('title'); ?>
    <?php echo app('translator')->get('Api'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <?php if(auth()->guard()->check()): ?>
        <div class="container">
            <ol class="breadcrumb center-items">
                <li><a href="<?php echo e(route('user.home')); ?>"><?php echo app('translator')->get('Home'); ?></a></li>
                <li class="active"><?php echo app('translator')->get('Api'); ?></li>
            </ol>
            <div class="row my-3">
                <div class="col-md-12">
                    <div class="card api-details">
                        <h5 class="card-title text-white"><?php echo app('translator')->get('API Key'); ?>
                            <button type="button" class="btn btn-default btn-sm  text-white float-right  waves-effect generateBtn"><i
                                    class="fa fa-spinner"></i> <?php echo app('translator')->get('Generate Key'); ?></button>
                        </h5>
                        <div class="card-body">

                            <div class="form-group content">
                                <h6 class="font-weight-bold mb-1"><?php echo app('translator')->get('API KEY'); ?></h6>
                                <div class="input-group">
                                    <input type="text" value="<?php echo e($api_token); ?>"
                                           class="form-control form-control-lg api-token" id="referralURL"
                                           readonly>
                                    <div class="input-group-append">
                                    <span class="input-group-text copytext copyBoard" id="copyBoard">
                                            <i class="fa fa-copy"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    <?php endif; ?>


    <!--API DETAILS-->
    <div class="container ">
        <div class="row">
            <div class="col-md-12">
                <div class="card api-details">
                    <h5 class="card-title text-white"><?php echo app('translator')->get('API DETAILS'); ?></h5>
                    <div class="card-body content">
                        <div class="row">
                            <div class="col-sm-12">
                                <h6><?php echo app('translator')->get('API URL'); ?></h6>
                                <p><?php echo e(route('userApiKey')); ?></p>
                            </div>
                            <div class="col-sm-12">
                                <h6><?php echo app('translator')->get('API KEY'); ?></h6>
                                <p>
                                    <?php echo app('translator')->get('Your API Key'); ?>
                                </p>
                            </div>
                            <div class="col-sm-3">
                                <h6><?php echo app('translator')->get('HTTP METHOD'); ?></h6>
                                <p><?php echo app('translator')->get('POST'); ?></p>
                            </div>
                            <div class="col-sm-3">
                                <h6><?php echo app('translator')->get('RESPONSE FORMAT'); ?></h6>
                                <p><?php echo app('translator')->get('JSON'); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!--PLACE NEW ORDER-->
    <div class="container ">
        <div class="row">
            <div class="col-md-12">
                <div class="card api-details mb-0">
                    <h5 class="card-title text-white"><?php echo app('translator')->get('PLACE NEW ORDER'); ?></h5>
                    <div class="card-body content">
                        <div class="row">
                            <div class="col-sm-3">
                                <h6 class="text-lowercase"><?php echo app('translator')->get('key'); ?></h6>
                                <p><?php echo app('translator')->get('Your API key'); ?></p>
                            </div>
                            <div class="col-sm-3">
                                <h6 class="text-lowercase"><?php echo app('translator')->get('action'); ?></h6>
                                <p>
                                    <?php echo app('translator')->get('add'); ?>
                                </p>
                            </div>
                            <div class="col-sm-3">
                                <h6 class="text-lowercase"><?php echo app('translator')->get('service'); ?></h6>
                                <p><?php echo app('translator')->get('Service ID'); ?></p>
                            </div>
                            <div class="col-sm-3">
                                <h6 class="text-lowercase"><?php echo app('translator')->get('link'); ?></h6>
                                <p><?php echo app('translator')->get('Link to page'); ?></p>
                            </div>

                            <div class="col-sm-3">
                                <h6 class="text-lowercase"><?php echo app('translator')->get('quantity'); ?></h6>
                                <p><?php echo app('translator')->get('Needed quantity'); ?></p>
                            </div>

                            <div class="col-sm-3">
                                <h6 class="text-lowercase"><?php echo app('translator')->get('runs'); ?>
                                    <small class="text-muted"><?php echo app('translator')->get('(optional)'); ?></small>
                                </h6>
                                <p><?php echo app('translator')->get('Runs to deliver'); ?></p>
                            </div>

                            <div class="col-sm-3">
                                <h6 class="text-lowercase"><?php echo app('translator')->get('interval'); ?>
                                    <small class="text-muted"><?php echo app('translator')->get('(optional)'); ?></small>
                                </h6>
                                <p><?php echo app('translator')->get('Interval in minutes'); ?></p>
                            </div>


                        </div>
                    </div>
                </div>
                <div class="api-code mt-2 mb-5">
                    <p class="text-success">//Example response</p>
                    <pre class="text-white">
{
    "status": "success",
    "order": 116
}
</pre>
                </div>
            </div>
        </div>
    </div>



    <!--STATUS ORDER-->
    <div class="container ">
        <div class="row">
            <div class="col-md-12">
                <div class="card api-details mb-0">
                    <h5 class="card-title text-white"><?php echo app('translator')->get('STATUS ORDER'); ?></h5>
                    <div class="card-body content">
                        <div class="row">
                            <div class="col-sm-4">
                                <h6 class="text-lowercase"><?php echo app('translator')->get('key'); ?></h6>
                                <p><?php echo app('translator')->get('Your API key'); ?></p>
                            </div>
                            <div class="col-sm-4">
                                <h6 class="text-lowercase"><?php echo app('translator')->get('action'); ?></h6>
                                <p>
                                    <?php echo app('translator')->get('status'); ?>
                                </p>
                            </div>
                            <div class="col-sm-4">
                                <h6 class="text-lowercase"><?php echo app('translator')->get('order'); ?></h6>
                                <p><?php echo app('translator')->get('Order ID'); ?></p>
                            </div>


                        </div>
                    </div>
                </div>

                <div class="api-code mt-2 mb-5">
                    <p class="text-success">//Example response</p>
                    <pre class="text-white">
{
    "status": "processing",
    "charge": "3.60",
    "start_count": 0,
    "remains": 0,
    "currency": "BDT"
}
</pre>
                </div>

            </div>
        </div>
    </div>



    <!--MULTIPLE STATUS ORDER-->
    <div class="container ">
        <div class="row">
            <div class="col-md-12">
                <div class="card api-details mb-0">
                    <h5 class="card-title text-white"><?php echo app('translator')->get('MULTIPLE STATUS ORDER'); ?></h5>
                    <div class="card-body content">
                        <div class="row">
                            <div class="col-sm-4">
                                <h6 class="text-lowercase"><?php echo app('translator')->get('key'); ?></h6>
                                <p><?php echo app('translator')->get('Your API key'); ?></p>
                            </div>
                            <div class="col-sm-4">
                                <h6 class="text-lowercase"><?php echo app('translator')->get('action'); ?></h6>
                                <p>
                                    <?php echo app('translator')->get('status'); ?>
                                </p>
                            </div>
                            <div class="col-sm-4">
                                <h6 class="text-lowercase"><?php echo app('translator')->get('orders'); ?></h6>
                                <p><?php echo app('translator')->get('Order IDs separated by comma (array data)'); ?></p>
                            </div>


                        </div>
                    </div>
                </div>

                <div class="api-code mt-2 mb-5">
                    <p class="text-danger">//Response (error)</p>
                    <pre class="text-white">{
    "errors": {
        "key": ["The key field is required."],
        "action": ["The action field is required."]
    }
}</pre>


                    <p class="text-success">//response (result)</p>

                    <pre class="text-white">[
    {
        "order": 116,
        "status": "processing",
        "charge": "3.60",
        "start_count": 0,
        "remains": 0
    },
    {
        "order": 117,
        "status": "processing",
        "charge": null,
        "start_count": 0,
        "remains": 0
    }
]</pre>
                </div>

            </div>
        </div>
    </div>


    <!--SERVICE LIST-->
    <div class="container ">
        <div class="row">
            <div class="col-md-12">
                <div class="card api-details mb-0">
                    <h5 class="card-title text-white"><?php echo app('translator')->get('SERVICE LIST'); ?></h5>
                    <div class="card-body content">
                        <div class="row">
                            <div class="col-sm-4">
                                <h6 class="text-lowercase"><?php echo app('translator')->get('key'); ?></h6>
                                <p><?php echo app('translator')->get('Your API key'); ?></p>
                            </div>
                            <div class="col-sm-4">
                                <h6 class="text-lowercase"><?php echo app('translator')->get('action'); ?></h6>
                                <p>
                                    <?php echo app('translator')->get('services'); ?>
                                </p>
                            </div>

                        </div>
                    </div>
                </div>

                <div class="api-code mt-2 mb-5">
                    <p class="text-success">//Example response</p>
                    <pre class="text-white">[
    {
        "service": 1,
        "name": "🙋‍♂️ Followers [Ultra-High Quality Profiles]",
        "category": "🥇 [VIP]\r\n",
        "rate": "4.80",
        "min": 100,
        "max": 10000
    },
    {
        "service": 11,
        "name": "🧨 Instagram Power Comments (100k+ Accounts) ➡️ [3 Comments]",
        "category": "💬 Instagram - Verified / Power Comments [ Own Service ]",
        "rate": "0.60",
        "min": 500,
        "max": 5000
    },
    {
        "service": 52,
        "name": "🎙️ Facebook Live Stream Views ➡️ [ 120 Min ]",
        "category": "🔵 Facebook - Live Stream Views\r\n",
        "rate": "57.60",
        "min": 50,
        "max": 2000
    }
]</pre>
                </div>

            </div>
        </div>
    </div>


    <!--USER BALANCE-->
    <div class="container ">
        <div class="row">
            <div class="col-md-12">
                <div class="card api-details mb-0">
                    <h5 class="card-title text-white"><?php echo app('translator')->get('USER BALANCE'); ?></h5>
                    <div class="card-body content">
                        <div class="row">
                            <div class="col-sm-4">
                                <h6 class="text-lowercase"><?php echo app('translator')->get('key'); ?></h6>
                                <p><?php echo app('translator')->get('Your API key'); ?></p>
                            </div>
                            <div class="col-sm-4">
                                <h6 class="text-lowercase"><?php echo app('translator')->get('action'); ?></h6>
                                <p>
                                    <?php echo app('translator')->get('balance'); ?>
                                </p>
                            </div>

                        </div>
                    </div>
                </div>

                <div class="api-code mt-2 mb-5">
                    <p class="text-success">//Example response</p>
                    <pre class="text-white">
{
  "status": "success",
  "balance": "0.03",
  "currency": "USD"
}
</pre>
                </div>

            </div>
        </div>
    </div>


<?php $__env->stopSection(); ?>



<?php $__env->startPush('js'); ?>

    <script>
        "use strict";
        $('.copyBoard').on('click',function () {
            var copyText = document.getElementById("referralURL");
            copyText.select();
            copyText.setSelectionRange(0, 99999);
            /*For mobile devices*/
            document.execCommand("copy");
            Notiflix.Notify.Success("Copied: " + copyText.value);
        });
        $('.generateBtn').on('click', function () {
            $.ajax({
                url: "<?php echo e(route('user.keyGenerate')); ?>",
                type: 'POST',
                success(data) {
                    $("#referralURL").val(data)

                    Notiflix.Notify.Success("KEY GENERATE: " + data);

                }
            });
        });

    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('user.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\server\htdocs\smmFinal\project\resources\views/user/pages/api/index.blade.php ENDPATH**/ ?>