<?php $__env->startSection('title'); ?>
    <?php echo app('translator')->get('Service'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid px-3 user-service-list">

        <div class="row   justify-content-between mx-lg-5">

            <div class="col-md-12">
                <ol class="breadcrumb center-items">
                    <li><a href="<?php echo e(route('user.home')); ?>"><?php echo app('translator')->get('Home'); ?></a></li>
                    <li class="active"><?php echo app('translator')->get('Service'); ?></li>
                </ol>

                <div class="card my-3">
                    <div class="card-body">
                        <form action="<?php echo e(route('user.service.search')); ?>" method="get">
                            <div class="row justify-content-between">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <input type="text" name="service" value="<?php echo e(@request()->service); ?>"
                                               class="form-control"
                                               placeholder="<?php echo app('translator')->get('Search for Services'); ?>">
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="form-group">
                                        <select name="category" id="category" class="form-control statusfield">
                                            <option value=""><?php echo app('translator')->get('All Category'); ?></option>
                                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option
                                                    value="<?php echo e($category->id); ?>" <?php echo e(($category->id == @request()->category) ? 'selected' : ''); ?>><?php echo app('translator')->get($category->category_title); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <button type="submit" class="btn waves-effect waves-light w-100 btn-primary"><i
                                                class="fas fa-search"></i> <?php echo app('translator')->get('Search'); ?></button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>


        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if( 0 < count($category->service)): ?>
                <div class="row my-3  justify-content-between mx-lg-5">
                    <div class="col-md-12">
                        <div class="card ">
                            <div class="card-body">
                                <h4 class="card-title mb-4"><?php echo e($category->category_title); ?>

                                    <a class="show-hide-icon float-right" data-toggle="collapse"
                                       href="#col-<?php echo e($category->id); ?>"
                                       aria-expanded="true" aria-controls="col-<?php echo e($category->id); ?>">
                                        <i class="fas fa-chevron-down"></i>
                                    </a>
                                </h4>


                                <div class="table-responsive collapse show" id="col-<?php echo e($category->id); ?>">
                                    <table class="categories-show-table table  table-striped text-dark">
                                        <thead>
                                        <tr>
                                            <th scope="col" class="text-center"><?php echo app('translator')->get('ID'); ?></th>
                                            <th scope="col" class="text-left"><?php echo app('translator')->get('Name'); ?></th>
                                            <th scope="col"
                                                class="text-center"><?php echo app('translator')->get('Rate Per 1k'); ?></th>
                                            <th scope="col" class="text-center"><?php echo app('translator')->get('Min'); ?></th>
                                            <th scope="col" class="text-center"><?php echo app('translator')->get('Max'); ?></th>
                                            <th scope="col" class="text-center"><?php echo app('translator')->get('Description'); ?></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php $__currentLoopData = $category->service; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td data-label="<?php echo app('translator')->get('ID'); ?>" class="text-center"><?php echo e($service->id); ?></td>
                                                <td data-label="<?php echo app('translator')->get('Name'); ?>" class="text-left">
                                                    <?php echo app('translator')->get($service->service_title); ?>
                                                </td>
                                                <td data-label="<?php echo app('translator')->get('Rate Per 1k'); ?>" class="text-center">
                                                   <?php echo app('translator')->get(config('basic.currency_symbol')); ?><?php echo e($service->user_rate ?? $service->price); ?>

                                                </td>
                                                <td data-label="<?php echo app('translator')->get('Min'); ?>" class="text-center">
                                                    <?php echo app('translator')->get($service->min_amount); ?>
                                                </td>
                                                <td data-label="<?php echo app('translator')->get('Max'); ?>" class="text-center">
                                                     <?php echo app('translator')->get($service->max_amount); ?>
                                                </td>

                                                <td data-label="<?php echo app('translator')->get('Description'); ?>" class="text-center">
                                                    <button type="button" class="btn btn-default btn-sm text-dark"
                                                            data-toggle="modal"
                                                            data-target="#description" id="details"
                                                            data-id="<?php echo e($service->id); ?>"
                                                            data-servicetitle="<?php echo e($service->service_title); ?>"
                                                            data-description="<?php echo e($service->description); ?>">
                                                        <i class="fa fa-eye"></i> <?php echo app('translator')->get('More'); ?></button>
                                                </td>

                                            </tr>

                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



    </div>

    <div class="modal fade" id="description">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header modal-colored-header bg-primary">
                    <h4 class="modal-title" id="title"></h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>

                <div class="modal-body" id="servicedescription">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                    <a href="" type="submit" class="btn btn-primary order-now"><?php echo app('translator')->get('Order Now'); ?></a>
                </div>

            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?>
    <script>
        "use strict";
        $(document).on('click', '#details', function () {
            var title = $(this).data('servicetitle');
            var id = $(this).data('id');

            var orderRoute = "<?php echo e(route('user.order.create')); ?>" + '?serviceId=' + id;
            $('.order-now').attr('href', orderRoute);

            var description = $(this).data('description');
            $('#title').text(title);
            $('#servicedescription').text(description);
        });
    </script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('user.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\server\htdocs\smmFinal\project\resources\views/user/pages/services/show-service.blade.php ENDPATH**/ ?>